/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.eventmon;

import com.ibm.hwmca.fw.eventmon.EventMonitorConstants;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class MonitoredEvent
implements EventMonitorConstants {
    ObjectId _source;
    Calendar _when;
    StringBuffer _log;

    public MonitoredEvent(ObjectId source, Calendar when) {
        this._source = source;
        this._when = when;
    }

    public abstract String getText();

    public abstract String getEventName();

    public ObjectId getSourceId() {
        return this._source;
    }

    public Calendar getWhen() {
        return this._when;
    }

    public String getSourceName() {
        return this.getSourceName(Locale.getDefault());
    }

    public String getSourceName(Locale locale) {
        String name = null;
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        HwmcaObject source = mom.get(this.getSourceId());
        name = source != null ? source.getUIInfo().getName(locale) : source.toString();
        return name;
    }

    public boolean isLogging() {
        return this._log != null;
    }

    public synchronized void setLogging(boolean setting) {
        if (setting) {
            if (this._log == null) {
                this._log = new StringBuffer();
            }
        } else if (this._log != null) {
            this._log = null;
        }
    }

    public String getLog() {
        return this._log.toString();
    }

    public synchronized void log(String text) {
        if (this._log != null) {
            this._log.append(text);
        }
    }

    public String getWhenString(Locale locale) {
        return DateFormat.getDateTimeInstance(2, 2, locale).format(this.getWhen().getTime());
    }

    public String getSourceString(Locale locale) {
        ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
        return mom.get(this.getSourceId()).getUIInfo().getTitle(locale);
    }

    public String dump() {
        return this.toString();
    }

    public String toString(Locale locale) {
        ResourceBundle resources = ResourceBundle.getBundle("com/ibm/hwmca/base/res/text", locale);
        StringBuffer buffer = new StringBuffer();
        buffer.append(resources.getString("eventmon.monitored.event"));
        buffer.append("\n  ");
        buffer.append(resources.getString("eventmon.name.colon"));
        buffer.append("  ");
        buffer.append(this.getEventName());
        buffer.append("\n  ");
        buffer.append(resources.getString("eventmon.time.colon"));
        buffer.append("  ");
        buffer.append(this.getWhenString(locale));
        buffer.append("\n  ");
        buffer.append(resources.getString("eventmon.text.colon"));
        buffer.append("  ");
        buffer.append(this.getText());
        buffer.append("\n  ");
        buffer.append(resources.getString("eventmon.source.colon"));
        buffer.append("  ");
        buffer.append(this.getSourceString(locale));
        return buffer.toString();
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }
}

